| package |
package := Package name: 'Pst-PalmOS-Base'.
package paxVersion: 0;
	basicComment: 'Pocket Smalltalk 1.6
Copyright (c) 1998-2001 www.PocketSmalltalk.com
GEOS changes and enhancements: Copyright (c) 1999, 2000 by Petr Novak
Toolbar enhancements: Copyright (c) 2000 by Joey Gibson (joeyGibson@mindspring.com)

This product is Open Source - see LICENSE.TXT for more information.
Home page: http://www.pocketsmalltalk.com
GEOS version home page: http://www.i.cz/PeN/pst9110.html
SE version: http://www.joeygibson.com/st

After filing in this package, evaluate the following to open a launcher (you can replace initSystem
with initGeosSystem or initPalmOSSystem):

	Pst initPalmOsSystem.
	PstLauncher show.'.

package basicPackageVersion: ''.

"Add the package scripts"

"Add the class names, loose method names, global names, resource names"
package classNames
	add: #PstPalmOSAPI;
	add: #PstPalmOSTrap;
	add: #PstPilotCodeGenerator;
	add: #PstPocketSmalltalkPalmOS;
	yourself.

package methodNames
	add: #PstSmalltalkParser -> #parsePalmOsCall;
	add: #PstSmalltalkParser -> #raiseExpectedValidPalmOsTypeFor:;
	add: 'Pst class' -> #initPalmOsSystem;
	yourself.

package globalNames
	yourself.

package resourceNames
	yourself.

"Binary Global Names"
package binaryGlobalNames: (Set new
	yourself).
"Resource Names"
package allResourceNames: (Set new
	yourself).

"Add the prerequisite names"
package setPrerequisites: (IdentitySet new
	add: 'Dolphin';
	add: 'Pst-Base';
	yourself).

package!

"Class Definitions"!

PstSmalltalkCodeGenerator subclass: #PstPilotCodeGenerator
	instanceVariableNames: 'database fileStream'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstOSAPI subclass: #PstPalmOSAPI
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstOSTrap subclass: #PstPalmOSTrap
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
PstSmalltalkSystem subclass: #PstPocketSmalltalkPalmOS
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
"Loose Methods"!

!Pst class methodsFor!

initPalmOsSystem

	self initUsingSystemClass: PstPocketSmalltalkPalmOS.! !
!Pst class categoriesFor: #initPalmOsSystem!initialization!public! !

!PstSmalltalkParser methodsFor!

parsePalmOsCall
	"	^	<???>
	Parse the oscall: returnType 'name' (argType1 argType2) library: 'libraryName'>.
	Answers the os call if parsing succeeded, or cause error if parsing does not."

	| trap returnType trapNumber argumentTypes |
	(token == #keyword and: [value = 'systrap:']) ifFalse: [
		self
			error: 'Expected either primitive or systrap'
			at: tokenStart].
	trap := PstPalmOSTrap new.
	self scanToken.
	(token == #identifier and: [(trap quietSpecForType: value asSymbol) notNil]) ifFalse: [
		self raiseExpectedValidPalmOsTypeFor: 'return'].
	returnType := value asSymbol.
	self scanToken.
	token == #integer ifFalse: [
		self
			error: 'Expected number of systrap'
			at: tokenStart.
		^nil].
	trapNumber := value.
	self scanToken.
	argumentTypes := #().
	token == $( ifTrue: [
		[self scanToken. token == $) or: [token isNil]] whileFalse: [
			(token == #identifier and: [(trap quietSpecForType: value asSymbol) notNil]) ifFalse: [
				self raiseExpectedValidPalmOsTypeFor: 'argument'].
			argumentTypes := argumentTypes copyWith: value asSymbol].
		token == $) ifFalse: [
			self
				error: 'Expected )'
				at: tokenStart].
		self scanToken].
	(token == #binop and: [value = '>']) ifFalse: [
		self
			error: 'Expected >'
			at: tokenStart].
	self scanToken.
	trap
		name: node keywords first
		functionNumber: trapNumber
		argumentTypes: argumentTypes
		returnType: returnType.
	^trap.!

raiseExpectedValidPalmOsTypeFor: purpose
	"	purpose	<String>
		^		void
	Raise the compiler error with info on what a valid type is."

		"See PstPalmOSTrap>>#quietSpecForType: for where this list comes from."
	self
		error: 'Expected a valid ', purpose, ' type:
	void
	int16
	int32
	pointer
	uint16
	double'
		at: tokenStart! !
!PstSmalltalkParser categoriesFor: #parsePalmOsCall!parsing!public! !
!PstSmalltalkParser categoriesFor: #raiseExpectedValidPalmOsTypeFor:!parsing!public! !

"End of package definition"!



PstPilotCodeGenerator comment: ''!

PstPilotCodeGenerator guid: (GUID fromString: '{5298E350-C77F-463C-8951-813246D53143}')!

!PstPilotCodeGenerator categoriesForClass!No category! !
!PstPilotCodeGenerator methodsFor!

addResourcesTo: resourceDatabase
	PstConstantsLibrary current resourceDatabases do: [:db |
		db resources do: [:resource |
			resourceDatabase addResource: resource]].!

databaseCreatorID
	| constant |
	(PstConstantsLibrary current hasConstantNamed: 'creatorID') ifTrue: [
		constant := PstConstantsLibrary current constantNamed: 'creatorID'.
		(constant value qclass name = 'String'
				and: [constant value indexedSlotCount = 4])
			ifTrue: [^constant value convertToString]].
	^'PkST'.!

databaseTitle
	| constant |
	(PstConstantsLibrary current hasConstantNamed: 'applicationTitle') ifTrue: [
		constant := PstConstantsLibrary current constantNamed: 'applicationTitle'.
		constant value qclass name = 'String'
			ifTrue: [^constant value convertToString]].
	^'PocketST App'.!

fileStream: stream
	fileStream := stream.!

writeClassNameData
	database addResource:
		(PstResource
			name: 'ClsN'
			id: 1
			contents: classNameData contents).!

writeClassOffsets
	| stream |
	stream := ByteArray new writeStream.
	classOffsets do: [:each |
		PstSystem current storeWord: each on: stream].
	database addResource:
		(PstResource
			name: 'ClsO'
			id: 1
			contents: stream contents).!

writeClassSegments
	classSegments keysAndValuesDo: [:index :each |
		database addResource:
			(PstResource
				name: 'ClsD'
				id: index
				contents: each)].!

writeHeader
	"don't really need to do anything."!

writeImageFile
	database := PstResourceDatabase new.
	database
		creatorID: self databaseCreatorID;
		title: self databaseTitle.

	self addResourcesTo: database.
	super writeImageFile.
	database writeOn: fileStream.!

writeObjectSegments
	objectSegments keysAndValuesDo: [:index :each |
		database addResource:
			(PstResource
				name: 'ObjD'
				id: index
				contents: each)].!

writeProperties
	database addResource: self properties asResource.!

writeSelectorData
	| data |
	selectorDataSegments add: selectorData contents.
	selectorDataSegments keysAndValuesDo: [:index :each |
		database addResource:
			(PstResource
				name: 'SelD'
				id: index
				contents: each)].! !
!PstPilotCodeGenerator categoriesFor: #addResourcesTo:!platform specific!public! !
!PstPilotCodeGenerator categoriesFor: #databaseCreatorID!parameters!public! !
!PstPilotCodeGenerator categoriesFor: #databaseTitle!parameters!public! !
!PstPilotCodeGenerator categoriesFor: #fileStream:!initialization!public! !
!PstPilotCodeGenerator categoriesFor: #writeClassNameData!platform specific!public! !
!PstPilotCodeGenerator categoriesFor: #writeClassOffsets!platform specific!public! !
!PstPilotCodeGenerator categoriesFor: #writeClassSegments!platform specific!public! !
!PstPilotCodeGenerator categoriesFor: #writeHeader!platform specific!public! !
!PstPilotCodeGenerator categoriesFor: #writeImageFile!platform specific!public! !
!PstPilotCodeGenerator categoriesFor: #writeObjectSegments!platform specific!public! !
!PstPilotCodeGenerator categoriesFor: #writeProperties!platform specific!public! !
!PstPilotCodeGenerator categoriesFor: #writeSelectorData!platform specific!public! !

!PstPilotCodeGenerator class methodsFor!

on: stream
	^self new fileStream: stream.! !
!PstPilotCodeGenerator class categoriesFor: #on:!instance creation!public! !



PstPalmOSAPI comment: ''!

PstPalmOSAPI guid: (GUID fromString: '{ED4B4A4A-4D51-4DD2-8F66-AB26FC873EED}')!

!PstPalmOSAPI categoriesForClass!No category! !
!PstPalmOSAPI class methodsFor!

serialTrapSpecs
	^#(
('SerOpen' #(int16 int16 int32) #int16 43009)
('SerClose' #(int16) #int16 43010)
('SerSleep' #(int16) #int16 43011)
('SerWake' #(int16) #int16 43012)
('SerGetSettings' #(int16 pointer) #int16 43013)
('SerSetSettings' #(int16 pointer) #int16 43014)
('SerGetStatus' #(int16 pointer pointer) #int16 43015)
('SerClearError' #(int16) #int16 43016)
('SerSend10' #(int16 pointer int32) #int16 43017)
('SerSendWait' #(int16 int32) #int16 43018)
('SerSendCheck' #(int16 pointer) #int16 43019)
('SerSendFlush' #(int16) #int16 43020)).
! !
!PstPalmOSAPI class categoriesFor: #serialTrapSpecs!*-unclassified!public! !



PstPalmOSTrap comment: ''!

PstPalmOSTrap guid: (GUID fromString: '{FC292CCE-D453-4AE4-ACD2-F03110B5DE62}')!

!PstPalmOSTrap categoriesForClass!No category! !
!PstPalmOSTrap methodsFor!

argumentCount
	^argumentTypes size.!

argumentWords
	^argumentTypes
		inject: 0
		into: [:words :type | words + (self wordsForType: type)].!

bytecodes
	"Answer the bytecodes, not including the initial opcode."
	| stream |
	stream := ByteArray new writeStream.
	stream
		nextPut: ((functionNumber bitShift: -8) bitAnd: 16rFF);
		nextPut: (functionNumber bitAnd: 16rFF);
		nextPut: self argumentCount.
	argumentTypes do: [:type |
		stream nextPut: (self specForType: type)].
	stream nextPut: (self specForType: returnType).
	^stream contents.
!

displayOn: stream
	stream
		print: functionNumber;
		nextPutAll: ': '.
	self printPrototypeOn: stream.!

name
	^name.!

name: trapName
functionNumber: number
argumentTypes: argTypes
returnType: retType
	name := trapName.
	functionNumber := number.
	argumentTypes := argTypes.
	returnType := retType.!

printOn: stream

	super printOn: stream.
	stream
		nextPutAll: ' (';
		display: self;
		nextPut: $).!

printPrototypeOn: stream
	stream
		nextPutAll: returnType;
		space;
		nextPutAll: name;
		nextPut: $(.
	argumentTypes
		do: [:each | stream nextPutAll: each]
		separatedBy: [stream nextPutAll: ', '].
	stream nextPut: $).!

prototype
	| stream |
	stream := String new writeStream.
	self printPrototypeOn: stream.
	^stream contents.!

quietSpecForType: type
	"	^	<Integer> | nil
	Return spec for type, if type is unknown then return nil."

	type == #void ifTrue: [^0].
	type == #int16 ifTrue: [^1].
	type == #int32 ifTrue: [^2].
	type == #pointer ifTrue: [^3].
true ifTrue: [^nil].
		"These types not supported by VM yet"
	type == #uint16 ifTrue: [^4].
	type == #double ifTrue: [^5].
	^nil!

specForType: type

	| result |
	result := self quietSpecForType: type.
	result isNil ifTrue: [
		self error].
	^result!

trapNumber
	^functionNumber.!

wordsForType: type
	type == #void ifTrue: [^0].
	(type == #int16 or: [type == #uint16]) ifTrue: [^1].
	(type == #int32 or: [type == #pointer]) ifTrue: [^2].
	type == #double ifTrue: [^4].
	self error.! !
!PstPalmOSTrap categoriesFor: #argumentCount!accessing!public! !
!PstPalmOSTrap categoriesFor: #argumentWords!accessing!public! !
!PstPalmOSTrap categoriesFor: #bytecodes!*-unclassified!public! !
!PstPalmOSTrap categoriesFor: #displayOn:!printing!public! !
!PstPalmOSTrap categoriesFor: #name!accessing!public! !
!PstPalmOSTrap categoriesFor: #name:functionNumber:argumentTypes:returnType:!initialization!public! !
!PstPalmOSTrap categoriesFor: #printOn:!printing!public! !
!PstPalmOSTrap categoriesFor: #printPrototypeOn:!printing!public! !
!PstPalmOSTrap categoriesFor: #prototype!printing!public! !
!PstPalmOSTrap categoriesFor: #quietSpecForType:!compiling!public! !
!PstPalmOSTrap categoriesFor: #specForType:!compiling!public! !
!PstPalmOSTrap categoriesFor: #trapNumber!accessing!public! !
!PstPalmOSTrap categoriesFor: #wordsForType:!public!utility! !



PstPocketSmalltalkPalmOS comment: ''!

PstPocketSmalltalkPalmOS guid: (GUID fromString: '{6D08B328-8323-47CE-984F-98275C5F1093}')!

!PstPocketSmalltalkPalmOS categoriesForClass!No category! !
!PstPocketSmalltalkPalmOS methodsFor!

codeGeneratorClass
	^PstPilotCodeGenerator.
!

compileOsCall: call on: compiler pop: pop forMessageNode: messageNode

	messageNode compileArgumentsOn: compiler.
	compiler systrap: call ignoreReturn: pop.!

doubleByteOrder
	^#[8 7 6 5 4 3 2 1]
!

osCallKeyword
	"	^	<String>
	Return the keyword that identifies an OS call in me."

	^'SYSTRAP'!

parseOsCallOnParser: parser
	"	parser		<PstParser>
		^				<???> | nil
	Return the os call that is present, nil if there is not one.
	I assume that the '<primitive: 111>' case has just been handled and that
	the '<' has already been skipped.
	Cause an error if there is an unknown type of OS call following."

	^parser parsePalmOsCall!

storeLongword: value on: stream
	"Big endian"
	self
		storeWord: (value bitShift: -16)
		on: stream.
	self
		storeWord: (value bitAnd: 16rFFFF)
		on: stream.!

storeWord: value on: stream
	"Big endian"
	stream
		nextPut: ((value bitShift: -8) bitAnd: 16rFF);
		nextPut: (value bitAnd: 16rFF).
!

trapClass
	^PstPalmOSTrap
! !
!PstPocketSmalltalkPalmOS categoriesFor: #codeGeneratorClass!parameters!public! !
!PstPocketSmalltalkPalmOS categoriesFor: #compileOsCall:on:pop:forMessageNode:!parameters!public! !
!PstPocketSmalltalkPalmOS categoriesFor: #doubleByteOrder!*-unclassified!public! !
!PstPocketSmalltalkPalmOS categoriesFor: #osCallKeyword!parameters!public! !
!PstPocketSmalltalkPalmOS categoriesFor: #parseOsCallOnParser:!*-unclassified!public! !
!PstPocketSmalltalkPalmOS categoriesFor: #storeLongword:on:!public!utility! !
!PstPocketSmalltalkPalmOS categoriesFor: #storeWord:on:!public!utility! !
!PstPocketSmalltalkPalmOS categoriesFor: #trapClass!parameters!public! !

!PstPocketSmalltalkPalmOS class methodsFor!

displayName
	"	^	<String>
	Return a descriptive string of me."

	^'Palm OS'!

generateSystrapsStFile
	"	^	self
	Generate the systraps.st file in my systemFilesPath folder.
	NOTE: See documentation of methods
		getTrapNumbers
		getTrapSpecs"
	"
	PstPocketSmalltalkPalmOS generateSystrapsStFile
	"

	| trapNumbers trapSpecs stream line spec |
	trapNumbers := self getTrapNumbers.
	trapSpecs := self getTrapSpecs.
	stream := PstCrossPlatformInterface
		openReadOnly: false
		fileNamed: (PstCrossPlatformInterface
			combinePath: self systemFilesPath
			withOtherPath: 'systraps.st')
		asText: true.
	stream nextPutAll: '!!"Pocket Smalltalk fileout - '.
	Time now printOn: stream.
	stream nextPutAll: ', '.
	Date today printOn: stream.
	stream nextPutAll: '"!!';
		cr; cr;
		nextPutAll: 'Object subclass: #SYSTRAP
	instanceVariableNames: ''''
	classVariableNames: ''''!!

!!SYSTRAP comment!!
I hold the definition of all Palm OS systraps.
!! !!

!!SYSTRAP class methodsFor: ''systrap''!!';
		cr.
	[trapSpecs keys asSortedCollection do: [:key |
		spec := trapSpecs at: key.
		stream cr; cr;
			nextPutAll: key.
		(spec at: 1) isEmpty ifFalse: [
			stream nextPutAll: ': arg1'.
			1 to: (spec at: 1) size - 1 do: [:i |
				stream nextPutAll: ' with: arg'.
				i + 1 printOn: stream]].
		stream cr; cr;
			nextPutAll: '	<systrap: ';
			nextPutAll: (spec at: 2);
			nextPutAll: ' '.
		(trapNumbers at: key) printOn: stream.
		(spec at: 1) isEmpty ifFalse: [
			stream nextPutAll: ' ('.
			(spec at: 1) do: [:each |
				stream nextPutAll: ' ';
					nextPutAll: each].
			stream nextPutAll: ')'].
		stream nextPutAll: '>!!'].
	stream nextPutAll: ' !!'.
	] ensure: [
		stream close].!

getTrapNumbers
	"	^	<Dictionary key: <String> value: <Integer>>
	Return the mapping of trap name to trap number.
	I look for a file named SysTraps.txt in my systemFilesPath.
	This is a file created from the SysTraps.h file from the Palm OS SDK.
	File has been trimmed to contain only the contents of the enums defining the
	trap numbers.
	A line with no tab indicates a hex number that starts the numbering in the enum.
	A line beginning with whitespace is a trap name, or comment '//'.  Each line
	with a trap causes the trap number to be incremented by one.  The trap name
	is computed by skipping whitespace, assuming the name starts with the prefix
	on the trap number line."
	"
	PstPocketSmalltalkPalmOS getTrapNumbers
	"

	| result trapNumber prefix stream line key |
	result := Dictionary new.
	stream := PstCrossPlatformInterface
		openReadOnly: true
		fileNamed: (PstCrossPlatformInterface
			combinePath: self systemFilesPath
			withOtherPath: 'SysTraps.txt')
		asText: true.
	[[stream atEnd] whileFalse: [
		line := stream nextLine.
		line isEmpty ifFalse: [
			line first isAlphaNumeric
				ifTrue: [
					line := ReadStream on: line.
					trapNumber := ('16r', (line upTo: $ ) asUppercase) asNumber.
					prefix := line upToEnd trimBlanks]
				ifFalse: [
					line := ReadStream on: line trimBlanks.
					(line atEnd or: [line peekFor: $/]) ifFalse: [
						key := (line upTo: $,) trimBlanks.
						key := key copyFrom: prefix size + 1 to: key size.
						result at: key put: trapNumber.
						trapNumber := trapNumber + 1]]]]
	] ensure: [
		stream close].
	^result!

getTrapSpecs
	"	^	<Dictionary key: <String> value: <Array>>
	Return the return and argument types of each trap.
	I assume the 'stackdia.txt' files exists in my systemFilesPath folder.
	This is a file we got from Quartus Forth. The file has been edited to
	remove all of the documentation at beginning of file.
	NOTE: There is something weird with the following traps in original stackdia.txt file
		PrgStartDialog trap name had to be modified to be PrgStartDialogV10"
	"
	PstPocketSmalltalkPalmOS getTrapSpecs
	"

	| result stream line info |
	result := Dictionary new.
	stream := PstCrossPlatformInterface
		openReadOnly: true
		fileNamed: (PstCrossPlatformInterface
			combinePath: self systemFilesPath
			withOtherPath: 'stackdia.txt')
		asText: true.
	[[stream atEnd] whileFalse: [
		line := stream nextLine trimBlanks.
		line isEmpty ifFalse: [
			info := self parseForthSpecLine: line.
			result at: (info at: 1) put: (info copyFrom: 2 to: info size)]]
	] ensure: [
		stream close].
	^result
!

parseForthArgSpec: string

	(string indexOfSubCollection: 'Handle.') ~= 0
		ifTrue: [^#pointer].
	(string indexOfSubCollection: 'VoidHand.') ~= 0
		ifTrue: [^#pointer].
	(string indexOfSubCollection: 'P.') ~= 0
		ifTrue: [^#pointer].
	(string indexOfSubCollection: 'H.') ~= 0
		ifTrue: [^#pointer].
	string = 'h.' ifTrue: [^#pointer].
	string = 'DmOpenRef.' ifTrue: [^#pointer].
	string first == $& ifTrue: [^#pointer].
	string last == $. ifTrue: [^#int32].
	string = ')' ifTrue: [^#void].
	^#int16.!

parseForthSpecLine: string
	"Answers an array: #(trapname (arg_array) return_type)"
	| tokens trapname args dashIndex return |
	tokens := string subStrings: Character space.
	tokens := tokens reject: [:each | each isEmpty].
	trapname := tokens first.
	dashIndex := tokens indexOf: '--'.
	args := ( tokens copyFrom: 3 to: dashIndex - 1 ) reverse.
	return := tokens at: dashIndex + 1.
	^Array
		with: trapname
		with: (args collect: [:each | self parseForthArgSpec: each])
		with: (self parseForthArgSpec: return).
!

systemFilesPath
	"	^	<String>
	Return the path to the system files needed to build a GEOS application.
	Files such as the base.st and vm executable.
	NOTE: The resulting path should NOT have the final '\' path delimeter."

	^'palmos'!

systemFilesToLoad
	"
	Answer a collection of file names that should be loaded into a new project."

	^#(
		'systraps.st'
		'core.st'
		'forms.st'
		)! !
!PstPocketSmalltalkPalmOS class categoriesFor: #displayName!*-unclassified!public! !
!PstPocketSmalltalkPalmOS class categoriesFor: #generateSystrapsStFile!generating!private! !
!PstPocketSmalltalkPalmOS class categoriesFor: #getTrapNumbers!generating!private! !
!PstPocketSmalltalkPalmOS class categoriesFor: #getTrapSpecs!generating!private! !
!PstPocketSmalltalkPalmOS class categoriesFor: #parseForthArgSpec:!generating!private! !
!PstPocketSmalltalkPalmOS class categoriesFor: #parseForthSpecLine:!generating!private! !
!PstPocketSmalltalkPalmOS class categoriesFor: #systemFilesPath!*-unclassified!public! !
!PstPocketSmalltalkPalmOS class categoriesFor: #systemFilesToLoad!*-unclassified!public! !

 
"Binary Globals"!

"Resources"!

